/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <vector>
#include <list>
#include <deque>
#include <set>
#include <algorithm>
using namespace std;

int main()
{
    list<int> coll1;

    // wstaw elementy od 1 do 9 do pierwszej kolekcji
    for (int i=1; i<=9; ++i) {
        coll1.push_back(i);
    }

    // przekopiuj elementy z kolekcji coll1 do coll2 dolaczajac je
    vector<int> coll2;
    copy (coll1.begin(), coll1.end(),      // zrodlo
          back_inserter(coll2));           // przeznaczenie

    // przekopiuj elementy z kolekcji coll1 do coll3 wstawiajac je na poczatku
    // - odwraca kolejnosc elementow
    deque<int> coll3;
    copy (coll1.begin(), coll1.end(),      // zrodlo
          front_inserter(coll3));          // przeznaczenie

    // przekopiuj elementy z kolekcji coll1 do coll4
    // - jedyny wstawiacz dzialajacy w przypadku kolekcji asocjacyjnych
    set<int> coll4;
    copy (coll1.begin(), coll1.end(),      // zrodlo
          inserter(coll4,coll4.begin()));  // przeznaczenie
}
