/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <list>
#include <algorithm>
#include "print.hpp"
using namespace std;

class IntSequence {
  private:
    int value;
  public:
    // konstruktor
    IntSequence (int initialValue)
     : value(initialValue) {
    }

    // "wywolanie funkcji"
    int operator() () {
        return value++;
    }
};

int main()
{
    list<int> coll;
    IntSequence seq(1);    // ciag liczb calkowitych rozpoczynajacy sie od wartosci 1

    // wstaw wartosci od 1 do 4
    // - przekaz obiekt funkcyjny przez referencje
    //     zeby generacja kontynuowana byla od wartosci 5
    generate_n<back_insert_iterator<list<int> >,
               int, IntSequence&>(back_inserter(coll),    // poczatek
                                  4,      // liczba elementow
                                  seq);   // generuje wartosci
    PRINT_ELEMENTS(coll);

    // wstaw wartosci od 42 do 45
    generate_n (back_inserter(coll),      // poczatek
                4,                        // liczba elementow
                IntSequence(42));         // generuje wartosci
    PRINT_ELEMENTS(coll);

    // kontynuuj z pierwszym ciagiem
    // - przekaz obiekt funkcyjny przez wartosc
    //     zeby generacja ponownie kontynuowana byla od wartosci 5
    generate_n (back_inserter(coll),      // poczatek
                4,                        // liczba elementow
                seq);                     // generuje wartosci
    PRINT_ELEMENTS(coll);
    
    // ponownie kontynuuj z pierwszym ciagiem
    generate_n (back_inserter(coll),      // poczatek
                4,                        // liczba elementow
                seq);                     // generuje wartosci
    PRINT_ELEMENTS(coll);
}
