/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <list>
#include <algorithm>
#include <functional>
#include <cstdlib>
#include "print.hpp"
#include "compose10.hpp"
using namespace std;


int main()
{
    list<int> coll;

    // wstaw 5 losowych liczb
    generate_n (back_inserter(coll),      // poczatek zakresu docelowego
                5,                        // liczba elementow
                rand);                    // generator nowych liczb
    PRINT_ELEMENTS(coll);

    // nadpisz piecioma nowymi liczbami losowymi
    // elementy z zakresu od 0 (wlacznie) do 10 (bez)
    generate (coll.begin(), coll.end(),   // zakres docelowy
              compose_f_g(bind2nd(modulus<int>(),10),
                          ptr_fun(rand)));
    PRINT_ELEMENTS(coll);
}
