/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <deque>
#include <string>
#include <algorithm>
#include <iterator>

using namespace std;

int main()
{
    // utworz pusta kolejke deque na lancuchy
    deque<string> coll;

    // wstaw kilka elementow
    coll.assign (3, string("lancuch"));
    coll.push_back ("ostatni lancuch");
    coll.push_front ("pierwszy lancuch");

    // wypisz elementy w oddzielnych wierszach
    copy (coll.begin(), coll.end(),
          ostream_iterator<string>(cout,"\n"));
    cout << endl;

    // usun pierwszy i ostatni element
    coll.pop_front();
    coll.pop_back();

    // wstaw lancuch "inny" do kazdego elementu oprocz pierwszego
    for (unsigned i=1; i<coll.size(); ++i) {
        coll[i] = "inny " + coll[i];
    }

    // zmien rozmiar na 4 elementy
    coll.resize (4, "lancuch zmiany rozmiaru");

    // wypisz elementy w oddzielnych wierszach
    copy (coll.begin(), coll.end(),
          ostream_iterator<string>(cout,"\n"));
}
