/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <algorithm>
#include <functional>
#include <iterator>
using namespace std;

int main()
{
    int coll[] = { 5, 6, 2, 4, 1, 3 };

    // podnies do kwadratu wszystkie elementy
    transform (coll, coll+6,        // pierwsze zrodlo
               coll,                // drugie zrodlo
               coll,                // przeznaczenie
               multiplies<int>());  // operacja

    // posortuj poczawszy od drugiego elementu
    sort (coll+1, coll+6);

    // wypisz wszystkie elementy
    copy (coll, coll+6,
          ostream_iterator<int>(cout," "));
    cout << endl;
}
