/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
/* ************************************************************
 *  Queue.hpp
 *   - bezpieczniejsza i wygodniejsza klasa kolejki
 * ************************************************************/
#ifndef QUEUE_HPP
#define QUEUE_HPP

#include <deque>
#include <exception>

template <class T>
class Queue {
  protected:
    std::deque<T> c;        // kontener na elementy

  public:
    /* klasa wyjatkow dla przypadku wywolania funkcji pop() oraz top() dla pustej kolejki
     */
    class ReadEmptyQueue : public std::exception {
      public:
        virtual const char* what() const throw() {
            return "odczyt pustej kolejki";
        }
    };
  
    // liczba elementow
    typename std::deque<T>::size_type size() const {
        return c.size();
    }

    // czy kolejka jest pusta?
    bool empty() const {
        return c.empty();
    }

    // do kolejki wstaw elementy
    void push (const T& elem) {
        c.push_back(elem);
    }

    // z kolejki odczytaj jeden element i zwroc jego wartosc
    T pop () {
        if (c.empty()) {
            throw ReadEmptyQueue();
        }
        T elem(c.front());
        c.pop_front();
        return elem;
    }

    // zwroc wartosc nastepnego elementu
    T& front () {
        if (c.empty()) {
            throw ReadEmptyQueue();
        }
        return c.front();
    }
};

#endif /* QUEUE_HPP */
