/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

// sprawdza czy element jest parzysty czy nieparzysty
bool checkEven (int elem, bool even)
{
    if (even) {
        return elem % 2 == 0;
    }
    else {
        return elem % 2 == 1;
    }
}

int main()
{
    vector<int> coll;

    INSERT_ELEMENTS(coll,1,9);
    PRINT_ELEMENTS(coll,"coll: ");

    /* argumenty dla funkcji checkEven()
     * - sprawdz obecnosc ciagu: "parzysta nieparzysta parzysta"
     */
    bool checkEvenArgs[3] = { true, false, true };

    // szukaj pierwszego podzakresu w kolekcji coll
    vector<int>::iterator pos;
    pos = search (coll.begin(), coll.end(),       // zakres
                  checkEvenArgs, checkEvenArgs+3, // wartosci podzakresu
                  checkEven);                     // kryterium podzakresu

    // wykonuj petle tak dlugo, jak dlugo znajdowany jest podzakres
    while (pos != coll.end()) {
        // wypisz pozycje pierwszego elementu
        cout << "znaleziono podzakres wystepujacy na pozycjach poczawszy od elementu "
             << distance(coll.begin(),pos) + 1
             << endl;

        // szukaj nastepnego podzakresu w kolekcji coll
        pos = search (++pos, coll.end(),              // zakres
                      checkEvenArgs, checkEvenArgs+3, // wartosci podzakresu
                      checkEven);                     // kryterium podzakresu
    }
}
