/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    list<int> coll;

    INSERT_ELEMENTS(coll,1,9);
    INSERT_ELEMENTS(coll,1,9);
    coll.sort ();
    PRINT_ELEMENTS(coll);

    // wypisz pierwsza i ostatnia pozycje, na ktorej moglaby zostac wstawiona wartosc 5
    list<int>::iterator pos1, pos2;

    pos1 = lower_bound (coll.begin(), coll.end(),
                        5);
    pos2 = upper_bound (coll.begin(), coll.end(),
                        5);

    cout << "wartosc 5 moglaby otrzymac pozycje od "
         << distance(coll.begin(),pos1) + 1
         << " do "
         << distance(coll.begin(),pos2) + 1
         << " bez naruszania uporzadkowania" << endl;

    // wstaw wartosc 3 na pierwszej mozliwej pozycji bez naruszania uporzadkowania
    coll.insert (lower_bound(coll.begin(),coll.end(),
                             3),
                 3);

    // wstaw wartosc 7 na ostatniej mozliwej pozycji bez naruszania uporzadkowania
    coll.insert (upper_bound(coll.begin(),coll.end(),
                             7),
                 7);

    PRINT_ELEMENTS(coll);
}

