/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
   deque<int> coll;

   INSERT_ELEMENTS(coll,1,6);
   PRINT_ELEMENTS(coll);

   // wypisz wszystkie roznice pomiedzy elementami
   adjacent_difference (coll.begin(), coll.end(),         // zrodlo
                        ostream_iterator<int>(cout," ")); // przezn.
   cout << endl;

   // wypisz wszystkie sumy z poprzednikami
   adjacent_difference (coll.begin(), coll.end(),         // zrodlo
                        ostream_iterator<int>(cout," "),  // przezn.
                        plus<int>());                     // operacja
   cout << endl;

   // wypisz wszystkie iloczyny pomiedzy elementami
   adjacent_difference (coll.begin(), coll.end(),         // zrodlo
                        ostream_iterator<int>(cout," "),  // przezn.
                        multiplies<int>());               // operacja
   cout << endl;
}
