/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <set>
#include <algorithm>
#include <iterator>
using namespace std;

int main()
{
    set<int> coll;

    // wstaw elementy od 1 do 9
    for (int i=1; i<=9; ++i) {
        coll.insert(i);
    }

    // wypisz wszystkie elementy kolekcji
    copy (coll.begin(), coll.end(),
          ostream_iterator<int>(cout," "));
    cout << endl;

    /* usun wszystkie elementy o wartosci 3
     * - nie dziala algorytm remove()
     * - dziala za to funkcja skladowa erase()
     */
    int num = coll.erase(3);

    // wypisz liczbe usunietych elementow
    cout << "liczba usunietych elementow: " << num << endl;

    // wypisz wszystkie elementy zmodyfikowanej kolekcji
    copy (coll.begin(), coll.end(),
          ostream_iterator<int>(cout," "));
    cout << endl;
}
