/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <valarray>
using namespace std;

// wyswietl wartosci umieszczone w tablicy wiersz po wierszu
template<class T>
void printValarray (const valarray<T>& va, int num)
{
    for (int i=0; i<va.size()/num; ++i) {
        for (int j=0; j<num; ++j) {
            cout << va[i*num+j] << ' ';
        }
        cout << endl;
    }
    cout << endl;
}

int main()
{
    /* tablica typu valarray z 12 elementami
     * - cztery wiersze
     * - trzy kolumny
     */
    valarray<double> va(12);

    // wypelnij tablice wartosciami
    for (int i=0; i<12; i++) {
        va[i] = i;
    }

    printValarray (va, 3);

    // pierwsza kolumna = druga kolumna podniesiona do potegi okreslonej przez trzecia kolumne
    va[slice(0,4,3)] = pow (valarray<double>(va[slice(1,4,3)]),
                            valarray<double>(va[slice(2,4,3)]));

    printValarray (va, 3);

    // utworz tablice valarray zawierajacej trzy razy trzeci element tablicy va
    valarray<double> vb(va[slice(2,4,0)]);

    // pomnoz trzecia kolumne przez elementy umieszczone w tablicy vb
    va[slice(2,4,3)] *= vb;

    printValarray (va, 3);

    // wyswietl pierwiastek kwadratowy elementow z drugiego wiersza
    printValarray (sqrt(valarray<double>(va[slice(3,3,1)])), 3);

    // pomnoz elementy trzeciego wiersza razy dwa
    va[slice(2,4,3)] = valarray<double>(va[slice(2,4,3)]) * 2.0;

    printValarray (va, 3);
}
