/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <complex>
using namespace std;

int main()
{
    /* liczba zespolona z czescia rzeczywista oraz urojona
     * - czesc rzeczywista: 4.0
     * - czesc urojona: 3.0
     */
    complex<double> c1(4.0,3.0);

    /* tworzy liczbe zespolona przy wykorzystaniu wspolrzednych biegunowych
     * - wartosc bezwzgledna: 5.0
     * - kat fazy: 0.75
     */
    complex<float> c2(polar(5.0,0.75));

    // wyswietla czesc rzeczywista oraz urojona liczb zespolonych
    cout << "c1: " << c1 << endl;
    cout << "c2: " << c2 << endl;

    // wyswietla liczby zespolone w postaci wspolrzednych zespolonych
    cout << "c1: modul: " << abs(c1)
         << " (kwadrat modulu: " << norm(c1) << ") "
         <<    " kat fazy: " << arg(c1) << endl;
    cout << "c2: modul: " << abs(c2)
         << " (kwadrat modulu: " << norm(c2) << ") "
         <<    " kat fazy: " << arg(c2) << endl;

    // wyswietla sprzezone liczby zespolone 
    cout << "c1 sprzezona liczba zespolona:  " << conj(c1) << endl;
    cout << "c2 sprzezona liczba zespolona:  " << conj(c2) << endl;

    // wyswietla wynik obliczen
    cout << "4.4 + c1 * 1.8: " << 4.4 + c1 * 1.8 << endl;

    /* wyswietla sume liczb c1 oraz c2:
     * - uwaga: uzyte zostaly rozne typy
     */
    cout << "c1 + c2:        "
         << c1 + complex<double>(c2.real(),c2.imag()) << endl;

    // dodaje pierwiastek kwadratowy liczby c1 do c1 oraz wyswietla wynik
    cout << "c1 += sqrt(c1): " << (c1 += sqrt(c1)) << endl;
}
