/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <cstdlib>
#include <iostream>
using namespace std;

int main()
{
    double x, y;        // argumenty

    // wyswietl naglowek
    cout << "Mnozenie dwoch liczb zmiennoprzecinkowych" << endl;

    // pobierz pierwszy argument
    cout << "pierwszy argument:  ";
    if (! (cin >> x)) {
        /* blad wejscia
         *  => wypisz komunikat o wystapieniu bledu i zakoncz program ze kodem bledu
         */
        cerr << "blad podczas odczytywania pierwszej wartosci rzeczywistej"
             << endl;
        return EXIT_FAILURE;
    }

    // pobierz drugi argument
    cout << "drugi argument: ";
    if (! (cin >> y)) {
        /* blad wejscia
         *  => wypisz komunikat o wystapieniu bledu i zakoncz program z kodem bledu
         */
        cerr << "blad podczas odczytywania drugiej wartosci rzeczywistej"
             << endl;
        return EXIT_FAILURE;
    }

    // wyswietl argumenty i wynik dzialania
    cout << x << " razy " << y << " wynosi " << x * y << endl;
}
