/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
// pliki naglowkowe dla operacji wejscia-wyjscia dla plikow
#include <iostream>
#include <fstream>

void printFileTwice (const char* filename)
{
    // otworz plik
    std::ifstream file(filename);

    // po raz pierwszy wypisz zawartosc pliku
    std::cout << file.rdbuf();

    // przesun na poczatek
    file.seekg(0);

    // po raz drugi wypisz zawartosc pliku
    std::cout << file.rdbuf();
}

int main (int argc, char* argv[])
{
    // wypisz dwukrotnie zawartosc wszystkich plikow przekazanych 
    // jako argumenty wiersza polecen
    for (int i=1; i<argc; ++i) {
        printFileTwice(argv[i]);
    }
}
