/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <vector>
#include <algorithm>
#include <functional>
#include "print.hpp"
#include "compose21.hpp"
using namespace std;

int main()
{
    vector<int> coll;

    // wstaw elementy od 1 do 9
    for (int i=1; i<=9; ++i) {
        coll.push_back(i);
    }
    PRINT_ELEMENTS(coll);

    // usun wszystkie elementy, ktore sa wieksze od 4 oraz mniejsze od 7
    // - zachowaj nowa pozycje konca
    vector<int>::iterator pos;
    pos = remove_if (coll.begin(),coll.end(),
                     compose_f_gx_hx(logical_and<bool>(),
                                     bind2nd(greater<int>(),4),
                                     bind2nd(less<int>(),7)));

    // usun "usuniete" elementy z kontenera coll
    coll.erase(pos,coll.end());

    PRINT_ELEMENTS(coll);
}
