/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    vector<int> coll1;
    deque<int> coll2;

    INSERT_ELEMENTS(coll1,1,9);
    INSERT_ELEMENTS(coll2,11,23);

    PRINT_ELEMENTS(coll1,"coll1: ");
    PRINT_ELEMENTS(coll2,"coll2: ");

    // wymien elementy kolekcji coll1 z odpowiadajacymi im elementami kolekcji coll2
    deque<int>::iterator pos;
    pos = swap_ranges (coll1.begin(), coll1.end(),  // pierwszy zakres
                       coll2.begin());              // drugi zakres

    PRINT_ELEMENTS(coll1,"\ncoll1: ");
    PRINT_ELEMENTS(coll2,"coll2: ");
    if (pos != coll2.end()) {
        cout << "pierwszy niezmodyfikowany element: "
             << *pos << endl;
    }

    // wymien pierwsze trzy elementy kolekcji coll2 z trzema ostatnimi
    swap_ranges (coll2.begin(), coll2.begin()+3,    // pierwszy zakres
                 coll2.rbegin());                   // drugi zakres

    PRINT_ELEMENTS(coll2,"\ncoll2: ");
}
