/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    vector<int> coll1;
    list<int> coll2;

    INSERT_ELEMENTS(coll1,1,6);

    for (int i=1; i<=16; i*=2) {
        coll2.push_back(i);
    }
    coll2.push_back(3);

    PRINT_ELEMENTS(coll1,"coll1: ");
    PRINT_ELEMENTS(coll2,"coll2: ");

    // znajdz pierwsza niezgodnosc
    pair<vector<int>::iterator,list<int>::iterator> values;
    values = mismatch (coll1.begin(), coll1.end(),  // pierwszy zakres
                       coll2.begin());              // drugi zakres
    if (values.first == coll1.end()) {
        cout << "brak niezgodnosci" << endl;
    }
    else {
        cout << "pierwsza niezgodnosc: "
             << *values.first  << " oraz "
             << *values.second << endl;
    }

    /* znajdz pierwsza pozycje, gdzie element kolekcji coll1 nie jest
     * mniejszy od odpowiadajacego mu elementu kolekcji coll2
     */
    values = mismatch (coll1.begin(), coll1.end(),  // pierwszy zakres
                       coll2.begin(),               // drugi zakres
                       less_equal<int>());          // kryterium
    if (values.first == coll1.end()) {
        cout << "zawsze mniejsze lub rowne" << endl;
    }
    else {
        cout << "nie mniejszy lub rowny: "
             << *values.first << " oraz "
             << *values.second << endl;
    }
}
