/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

void printCollection (const list<int>& l)
{
    PRINT_ELEMENTS(l);
}

bool lessForCollection (const list<int>& l1, const list<int>& l2)
{
    return lexicographical_compare
                (l1.begin(), l1.end(),   // pierwszy zakres
                 l2.begin(), l2.end());  // drugi zakres
}

int main()
{
    list<int> c1, c2, c3, c4;

    // wypelnij wszystkie kolekcje tymi samymi wartosciami poczatkowymi
    INSERT_ELEMENTS(c1,1,5);
    c4 = c3 = c2 = c1;

    // a teraz kilka roznic
    c1.push_back(7);
    c3.push_back(2);
    c3.push_back(0);
    c4.push_back(2);

    // utworz kolekcje kolekcji
    vector<list<int> > cc;

    cc.push_back(c1);
    cc.push_back(c2);
    cc.push_back(c3);
    cc.push_back(c4);
    cc.push_back(c3);
    cc.push_back(c1);
    cc.push_back(c4);
    cc.push_back(c2);

    // wypisz wszystkie kolekcje
    for_each (cc.begin(), cc.end(),
              printCollection);
    cout << endl;

    // posortuj kolekcje leksykograficznie
    sort (cc.begin(), cc.end(),    // zakres
          lessForCollection);      // kryterium sortowania

    // ponownie wypisz wszystkie kolekcje
    for_each (cc.begin(), cc.end(),
              printCollection);
}
