/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
/* klasa auto_ptr
 * - ulepszona implementacja zgodna ze standardem
 */
namespace std {
    // typ pomocniczy umozliwiajacy kopiowanie i operacje przypisania (teraz globalny)
    template<class Y>
    struct auto_ptr_ref {
        Y* yp;
        auto_ptr_ref (Y* rhs)
         : yp(rhs) {
        }
    };

    template<class T>
    class auto_ptr {
      private:
        T* ap;    // odnosi sie do aktualnie posiadanego obiektu (jesli taki jest)
      public:
        typedef T element_type;

        // konstruktor
        explicit auto_ptr (T* ptr = 0) throw()
         : ap(ptr) {
        }

        // konstruktory kopiujace (wykorzystujace konwersje niejawna)
        // - uwaga: niestaly parametr
        auto_ptr (auto_ptr& rhs) throw()
         : ap(rhs.release()) {
        }
        template<class Y>
        auto_ptr (auto_ptr<Y>& rhs) throw()
         : ap(rhs.release()) {
        }
        
        // operatory przypisania  (wykorzystujace konwersje niejawna)
        // - uwaga: niestaly parametr
        auto_ptr& operator= (auto_ptr& rhs) throw() {
            reset(rhs.release());
            return *this;
        }
        template<class Y>
        auto_ptr& operator= (auto_ptr<Y>& rhs) throw() {
            reset(rhs.release());
            return *this;
        }
        
        // destruktor
        ~auto_ptr() throw() {
            delete ap;
        }

        // dostep do wartosci
        T* get() const throw() {
            return ap;
        }
        T& operator*() const throw() {
            return *ap;
        }
        T* operator->() const throw() {
            return ap;
        }

        // zwolnij wlasnosc
        T* release() throw() {
            T* tmp(ap);
            ap = 0;
            return tmp;
        }

        // ustaw wartosc ponownie (lub wyzeruj jesli bez argumentu)
        void reset (T* ptr=0) throw() {
            if (ap != ptr) {
                delete ap;
                ap = ptr;
            }
        }

        /* specjalne konwersje wykorzystujace typ pomocniczy umozliwiajace kopiowanie i operacje przypisania
         */
        auto_ptr(auto_ptr_ref<T> rhs) throw()
         : ap(rhs.yp) {
        }
        auto_ptr& operator= (auto_ptr_ref<T> rhs) throw() {  // nowy operator
             reset(rhs.yp);
             return *this;
        }
        template<class Y>
        operator auto_ptr_ref<Y>() throw() {
            return auto_ptr_ref<Y>(release());
        }
        template<class Y>
        operator auto_ptr<Y>() throw() {
            return auto_ptr<Y>(release());
        }
    };
}
