/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <string>
#include <algorithm>
#include <locale>
#include <iterator>
using namespace std;

class bothWhiteSpaces {
  private:
    const locale& loc;    // zmienna okreslajaca cechy narodowe
  public:
    /* konstruktor
     * - zachowuje obiekt locale
     */
    bothWhiteSpaces (const locale& l) : loc(l) {
    }
    /* wywolanie funkcji
     * - zwraca wartosc logiczna okreslajaca czy oba znaki sa znakami bialymi
     */
    bool operator() (char elem1, char elem2) {
        return isspace(elem1,loc) && isspace(elem2,loc);
    }
};

int main()
{
    string contents;

    // nie pomijaj poczatkowych bialych znakow
    cin.unsetf (ios::skipws);

    // odczytaj wszystkie znaki podczas kompresowania bialych znakow
    unique_copy(istream_iterator<char>(cin),    // poczatek zrodla
                istream_iterator<char>(),       // koniec zrodla
                back_inserter(contents),        // lancuch docelowy
                bothWhiteSpaces(cin.getloc())); // kryterium uzywane podczas usuwania

    // przetworz zawartosc
    // - w tym przypadku wypisz ja na standardowe wyjscie
    cout << contents;
}
