/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <string>
#include <iostream>
#include <algorithm>
using namespace std;

int main()
{
    // utworz lancuch znakowy
    const string hello("Czesc, jak sie miewasz?");

    // utworz lancuch znakowy s inicjalizujac go wszystkimi znakami lancucha hello
    string s(hello.begin(),hello.end());

    // przejdz przez wysztkie znaki
    string::iterator pos;
    for (pos = s.begin(); pos != s.end(); ++pos) {
        cout << *pos;
    }
    cout << endl;

    // odwroc kolejnosc wszystkich znakow w lancuchu
    reverse (s.begin(), s.end());
    cout << "odwrocona kolejnosc:       " << s << endl;

    // posortuj wszystkie znaki w lancuchu
    sort (s.begin(), s.end());
    cout << "uporzadkowane:       " << s << endl;

    /* usun wszystkie zbedne duplikacty
     * - unique() zmienia porzadek i zwraca nowy koniec lancucha
     * - erase() odpowiedni zmniejsza lancuch
     */
    s.erase (unique(s.begin(),
                    s.end()),
             s.end());
    cout << "brak duplikatow: " << s << endl;
}
