/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <string>
#include <iostream>
#include <algorithm>
using namespace std;

bool nocase_compare (char c1, char c2)
{
    return toupper(c1) == toupper(c2);
}

int main()
{
    string s1("To jest lancuch znakowy");
    string s2("LANCUCH");
    
    // porownaj lancuchy znakowe bez wzgledu na wielkosc liter
    if (s1.size() == s2.size() &&        // upewnij sie ze maja ten sam rozmiar
        equal (s1.begin(),s1.end(),      // pierwszy zrodlowy lancuch znakowy
               s2.begin(),               // drugi zrodlowy lancuch znakowy
               nocase_compare)) {        // kryterium porownania
        cout << "oba lancuchy znakowe sa jednakowe" << endl;
    }
    else {
        cout << "lancuchy znakowe sa rozne" << endl;
    }

    // przeszukaj lancuchy znakowe bez wzgledu na wielkosc liter
    string::iterator pos;
    pos = search (s1.begin(),s1.end(),   // lancuch zrodlowy ktory bedzie przeszukiwany
                  s2.begin(),s2.end(),   // szukane wyrazenie
                  nocase_compare);       // kryterium porownania
    if (pos == s1.end()) {
        cout << "s2 nie stanowi czesci s1" << endl;
    }
    else {
        cout << '"' << s2 << "\" stanowi czesc lancucha \""
             << s1 << "\" (od miejsca " << pos - s1.begin() << ")"
             << endl;
    }
}

