/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <string>
#include <deque>
#include <set>
#include <algorithm>
using namespace std;


/* klasa Person
 */
class Person {
  private:
    string fn;    // imie
    string ln;    // nazwisko
  public:
    Person() {
    }
    Person(const string& f, const string& n)
     : fn(f), ln(n) {
    }
    string firstname() const;
    string lastname() const;
    // ...
};

inline string Person::firstname() const {
    return fn;
}

inline string Person::lastname() const {
    return ln;
}

ostream& operator<< (ostream& s, const Person& p)
{
    s << "[" << p.firstname() << " " << p.lastname() << "]";
    return s;
}


/* predykat funkcyjny dwuargumentowy:
 * - zwraca czy dana osoba jest 'mniejsza' ni druga osoba
 */
bool personSortCriterion (const Person& p1, const Person& p2)
{
    /* osoba jest 'mniejsza' ni druga osoba
     * - jesli nazwisko jest 'mniejsze'
     * - jesli nazwisko jest 'rowne' oraz imie jest 'mniejsze'
     */
    return p1.lastname()<p2.lastname() ||
           (!(p2.lastname()<p1.lastname()) &&
            p1.firstname()<p2.firstname());
}

int main()
{
    // utworz kilka osob
    Person p1("jan","kowalski");
    Person p2("anna","kowalska");
    Person p3("jacek","kowalski");
    Person p4("piotr","nowak");
    Person p5("pawel","zalewski");
    Person p6("jacek","baran");
    Person p7("jacek","marzec");
    
    // wstaw osobe do kolekcji coll
    deque<Person> coll;
    coll.push_back(p1);
    coll.push_back(p2);
    coll.push_back(p3);
    coll.push_back(p4);
    coll.push_back(p5);
    coll.push_back(p6);
    coll.push_back(p7);

    // wypisz elementy
    cout << "kontener deque przed wykonaniem funkcji sort():" << endl;
    deque<Person>::iterator pos;
    for (pos = coll.begin(); pos != coll.end(); ++pos) {
        cout << *pos << endl;
    }

    // posortuj elementy
    sort(coll.begin(),coll.end(),    // zakres
         personSortCriterion);       // kryterium sortowania

    // wypisz elementy
    cout << "kontener deque po wykonaniu funkcji sort():" << endl;
    for (pos = coll.begin(); pos != coll.end(); ++pos) {
        cout << *pos << endl;
    }
}

