/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <set>
#include <deque>
#include <algorithm>
#include "print.hpp"
using namespace std;

int main()
{
    set<int,greater<int> > coll1;
    deque<int> coll2;

    // wstaw elementy od 1 do 9
    for (int i=1; i<=9; ++i) {
        coll1.insert(i);
    }

    PRINT_ELEMENTS(coll1,"wartosci poczatkowe: ");

    // transformuj wszystkie elementy do kolekcji coll2 mnozac je przez 10
    transform (coll1.begin(),coll1.end(),        // zrodlo
               back_inserter(coll2),             // przeznaczenie
               bind2nd(multiplies<int>(),10));   // operacja

    PRINT_ELEMENTS(coll2,"po transformacji:    ");

    // zastap element o wartosci 70 wartoscia 42
    replace_if (coll2.begin(),coll2.end(),       // zakres
                bind2nd(equal_to<int>(),70),     // kryterium zastapienia
                42);                             // nowa wartosc

    PRINT_ELEMENTS(coll2,"po zastapieniu:      ");

    // usun wszystkie elementy o wartosciach mniejszych od 50
    coll2.erase(remove_if(coll2.begin(),coll2.end(), // zakres
                          bind2nd(less<int>(),50)),  // kryterium usuniecia
                coll2.end());

    PRINT_ELEMENTS(coll2,"po usunieciu:        ");
}
