/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <valarray>
using namespace std;

// wyswietl elementy tablicy valarray wiersz po wierszu
template<class T>
void printValarray (const valarray<T>& va, int num)
{
    for (int i=0; i<va.size()/num; ++i) {
        for (int j=0; j<num; ++j) {
            cout << va[i*num+j] << ' ';
        }
        cout << endl;
    }
    cout << endl;
}

int main()
{
    /* tablica typu valarray zawierajaca 12 elementow
     * - cztery wiersze
     * - trzy kolumny
     */
    valarray<double> va(12);

    // wypelnij tablice wartosciami
    for (int i=0; i<12; i++) {
        va[i] = i;
    }

    printValarray (va, 3);

    // przypisz wartosc 77 wszystkim elementom posiadajacym wartosc mniejsza niz 5
    va[va<5.0] = 77.0;

    // dodaj 100 do wszystkich elementow posiadajcych wartosc wieksza niz 5 i mniejsza niz 9
    va[va>5.0 && va<9.0]
        = valarray<double>(va[va>5.0 && va<9.0]) + 100.0;

    printValarray (va, 3);
}
