/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <complex>
#include <cstdlib>
#include <limits>
using namespace std;

int main()
{
    complex<long double> c1, c2;

    while (cin.peek() != EOF) {

        // odzczytaj pierwsza liczbe zespolona
        cout << "liczba zespolona c1: ";
        cin >> c1;
        if (!cin) {
            cerr << "blad podczas operacji odczytu" << endl;
            return EXIT_FAILURE;
        }

        // odczytaj druga lcizbe zespolona
        cout << "liczba zespolona c2: ";
        cin >> c2;
        if (!cin) {
            cerr << "blad podczas operacji odczytu" << endl;
            return EXIT_FAILURE;
        }

        if (c1 == c2) {
            cout << "liczby c1 oraz c2 sa rowne !" << endl;
        }

        cout << "liczba c1 podniesiona do potegi c2: " << pow(c1,c2)
             << endl << endl;

        // pomin reszte wiersza
        cin.ignore(numeric_limits<int>::max(),'\n');
    }
}
