/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

int main()
{
    vector<int> coll;

    // wstaw elementy od 1 do 9
    for (int i=1; i<=9; ++i) {
        coll.push_back(i);
    }

    // ustal pozycje elementu o wartosci 5
    vector<int>::iterator pos;
    pos = find (coll.begin(), coll.end(),
                5);

    // wypisz wartosc, do ktorej odnosi sie iterator pos
    cout << "pos:  " << *pos << endl;

    // konwertuj iterator na iterator odwrotny rpos
    vector<int>::reverse_iterator rpos(pos);

    // wypisz wartosc, do ktorej odnosi sie iterator odwrotny rpos
    cout << "rpos: " << *rpos << endl;
}
