/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <list>
#include <algorithm>
using namespace std;

void print (int elem)
{
    cout << elem << ' ';
}

int main()
{
    list<int> coll;

    // wstaw elementy od 1 do 9
    for (int i=1; i<=9; ++i) {
        coll.push_back(i);
    }

    // wypisz wszystkie elementy w normalnej kolejnosci
    for_each (coll.begin(), coll.end(),      // zakres
              print);                        // operacja
    cout << endl;

    // wypisz wszystkie elementy w odwrotnej kolejnosci
    for_each (coll.rbegin(), coll.rend(),    // zakres
              print);                        // operacja
    cout << endl;
}
