/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <set>
#include <algorithm>
using namespace std;

#include "print.hpp"

#include "assoiter.hpp"

int main()
{
    set<int> coll;   

    // utworz wstawiacz dla kontenera coll
    // - niewygodny sposob
    asso_insert_iterator<set<int> > iter(coll);

    // wstaw elementy z wykorzystaniem typowego interfejsu iteratora
    *iter = 1;
    iter++;
    *iter = 2;
    iter++;
    *iter = 3;

    PRINT_ELEMENTS(coll);

    // utworz wstawiacz dla kontenera coll i wstaw elementy
    // - wygodny sposob
    asso_inserter(coll) = 44;
    asso_inserter(coll) = 55;

    PRINT_ELEMENTS(coll);

    // uzyj wstawiacza z algorytmem
    int vals[] = { 33, 67, -4, 13, 5, 2 };
    copy (vals, vals+(sizeof(vals)/sizeof(vals[0])),  // zrodlo
          asso_inserter(coll));                       // przeznaczenie

    PRINT_ELEMENTS(coll);
}
