/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <streambuf>
#include <locale>
#include <cstdio>

class outbuf : public std::streambuf
{
  protected:
    /* glowna funkcja wyjsciowa
     * - wyswietla znaki w trybie uppercase 
     */
    virtual int_type overflow (int_type c) {
        if (c != EOF) {
            // konwertuje male litery na duze
            c = std::toupper(c,getloc());

            // i zapisuje znak na standardowe wyjscie
            if (putchar(c) == EOF) {
                return EOF;
            }
        }
        return c;
    }
};
