/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
// pliki naglowkowe dla operacji wejscia-wyjscia na plikach
#include <fstream>
#include <iostream>
using namespace std;

/* dla wszystkich nazw plikow przekzazanych w charakterze argumentow z wiersza polecen
 * - otworz, wyswietl zawartosc, oraz zamknij plik
 */
int main (int argc, char* argv[])
{
    ifstream file;

    // dla wszystkich argumentow wiersza polecen
    for (int i=1; i<argc; ++i) {

        // otworz plik
        file.open(argv[i]);

        // zapisz zawartosc pliku do strumienia cout
        char c;
        while (file.get(c)) {
            cout.put(c);
        }

        // wyczysc znaczniki eofbit oraz failbit ustawione z powodu napotkania znaku konca pliku
        file.clear();

        // zamknij plik
        file.close();
    }
}
