/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <stack>
using namespace std;

int main()
{
    stack<int> st;

    // poloz trzy elementy na stos
    st.push(1);
    st.push(2);
    st.push(3);

    // ze stosu zdejmij i wypisz dwa elementy
    cout << st.top() << ' ';
    st.pop();
    cout << st.top() << ' ';
    st.pop();

    // zmodyfikuj szczytowy element
    st.top() = 77;

    // poloz dwa nowe elementy
    st.push(4);
    st.push(5);

    // zdejmij jeden element nie przetwarzajac go
    st.pop();

    // zdejmij i wypisz pozostale elementy
    while (!st.empty()) {
        cout << st.top() << ' ';
        st.pop();
    }
    cout << endl;
}
