/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <set>
#include "print.hpp"
using namespace std;

// typ dla kryterium sortowania
template <class T>
class RuntimeCmp {
  public:
    enum cmp_mode {normal, reverse};
  private:
    cmp_mode mode;
  public:  
    // konstruktor dla kryterium sortowania
    // - kryterium domyslne wykorzystuje wartosc normal
    RuntimeCmp (cmp_mode m=normal) : mode(m) {
    }
    // porownanie elementow
    bool operator() (const T& t1, const T& t2) const {
        return mode == normal ? t1 < t2 : t2 < t1;
    }
    // porownanie kryteriow sortowania
    bool operator== (const RuntimeCmp& rc) {
        return mode == rc.mode;
    }
};

// typ zbioru wykorzystujacego to kryterium sortowania
typedef set<int,RuntimeCmp<int> > IntSet;

// deklaracja zapowiadajaca
void fill (IntSet& set);

int main()
{
    // utworz, wypelnij i wyswietl zbior o normalnej kolejnosci elementow
    // - wykorzystuje domyslne kryterium sortowania
    IntSet coll1;
    fill(coll1);
    PRINT_ELEMENTS (coll1, "coll1: ");

    // utworz kryterium sortowania o odwrotnej kolejnosci elementow
    RuntimeCmp<int> reverse_order(RuntimeCmp<int>::reverse);

    // utworz, wypelnij i wyswietl zbior o odwrotnej kolejnosci elementow
    IntSet coll2(reverse_order);
    fill(coll2);
    PRINT_ELEMENTS (coll2, "coll2: ");

    // przypisz elementy ORAZ kryterium sortowania
    coll1 = coll2;
    coll1.insert(3);
    PRINT_ELEMENTS (coll1, "coll1: ");

    // tylko dla upewnienia sie...
    if (coll1.value_comp() == coll2.value_comp()) {
        cout << "zbiory coll1 oraz coll2 posiadaja to samo kryterium sortowania"
             << endl;
    }
    else {
        cout << "zbiory coll1 oraz coll2 posiadaja rozne kryteria sortowania"
             << endl;
    }
}

void fill (IntSet& set)
{
    // wstaw elementy w przypadkowej kolejnosci
    set.insert(4);
    set.insert(7);
    set.insert(5);
    set.insert(1);
    set.insert(6);
    set.insert(2);
    set.insert(5);
}
