/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <map>
#include <string>
using namespace std;

int main()
{
    /* utworz mape / tablice asocjacyjna
     * - klucze sa typu string
     * - wartosci sa typu float
     */
    typedef map<string,float> StringFloatMap;

    StringFloatMap stocks;      // utworz pusty kontener

    // wstaw kilka elementow
    stocks["Agora"] = 44.50;
    stocks["COMPLAND"] = 86.00;
    stocks["Zywiec"] = 348.00;
    stocks["KGHM"] = 13.30;
    stocks["Okocim"] = 13.15;

    // wypisz wszystkie elementy
    StringFloatMap::iterator pos;
    for (pos = stocks.begin(); pos != stocks.end(); ++pos) {
        cout << "spolka: " << pos->first << " "
             << "cena: " << pos->second << endl;
    }
    cout << endl;

    // hossa (wszystkie ceny zostaja podwojone)
    for (pos = stocks.begin(); pos != stocks.end(); ++pos) {
        pos->second *= 2;
    }

    // wypisz wszystkie elementy
    for (pos = stocks.begin(); pos != stocks.end(); ++pos) {
        cout << "spolka: " << pos->first << " "
             << "cena: " << pos->second << endl;
    }
    cout << endl;

    /* zmien nazwe klucza "COMPLAND" na "ComputerLand"
     * - operacja mozliwa jedynie przez zamiane elementu
     */
    stocks["ComputerLand"] = stocks["COMPLAND"];
    stocks.erase("COMPLAND");

    // wypisz wszystkie elementy
    for (pos = stocks.begin(); pos != stocks.end(); ++pos) {
        cout << "spolka: " << pos->first << " "
             << "cena: " << pos->second << endl;
    }
}
