/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <bitset>
#include <iostream>
using namespace std;

int main()
{
    /* typ wyliczeniowy reprezentowany na bitach
     * - kazdy bit odpowiada jednemu kolorowi
     */
    enum Color { red, yellow, green, blue, white, black, //...,
                 numColors };

    // utworz zbior bitowy na wszystkie bity (kolory)
    bitset<numColors> usedColors;

    // ustaw bity na dwoch kolorach
    usedColors.set(red);
    usedColors.set(blue);

    // wypisz niektore dane ze zbioru bitowego
    cout << "pole bitowe uzywanych kolorow:    " << usedColors
         << endl;
    cout << "liczba uzywanych kolorow:         " << usedColors.count()
         << endl;
    cout << "pole bitowe nieuzywanych kolorow: " << ~usedColors
         << endl;

    // jesli jakis kolor jest uzywany
    if (usedColors.any()) {
        // wykonuj petle po wszystkich kolorach
        for (int c = 0; c < numColors; ++c) {
            // jesli biezacy kolor jest uzywany
            if (usedColors[(Color)c]) {
                //...
            }
        }
    }
}
