/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    // dane zrodlowe
    int source[] = { 1, 4, 4, 6, 1, 2, 2, 3, 1, 6, 6, 6, 5, 7,
                      5, 4, 4 };
    int sourceNum = sizeof(source)/sizeof(source[0]);

    list<int> coll;

    // zainicjalizuj kolekcje coll elementami z tablicy source
    copy (source, source+sourceNum,           // zrodlo
          back_inserter(coll));               // przeznaczenie
    PRINT_ELEMENTS(coll);

    // usun kolejne powtorzenia
    list<int>::iterator pos;
    pos = unique (coll.begin(), coll.end());

    /* wypisz nieusuniete elementy
     * - uzyj nowego logicznego konca
     */
    copy (coll.begin(), pos,                  // zrodlo
          ostream_iterator<int>(cout," "));   // przeznaczenie
    cout << "\n\n";

    // ponownie zainicjalizuj kolekcje coll elementami z tablicy source
    copy (source, source+sourceNum,           // zrodlo
          coll.begin());                      // przeznaczenie
    PRINT_ELEMENTS(coll);

    // usun elementy, jesli istnieje wczesniejszy element o wiekszej wartosci
    coll.erase (unique (coll.begin(), coll.end(),
                        greater<int>()),
                coll.end());
    PRINT_ELEMENTS(coll);
}
