/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
   deque<int> coll;

   INSERT_ELEMENTS(coll,1,9);
   PRINT_ELEMENTS(coll);

   // znajdz cztery kolejne elementy o wartosci 3
   deque<int>::iterator pos;
   pos = search_n (coll.begin(), coll.end(),    // zakres
                   4,                           // liczba elementow
                   3);                          // wartosc

   // wypisz wynik
   if (pos != coll.end()) {
       cout << "cztery kolejne elementy o wartosci 3 "
            << "wystepuja na pozycjach poczawszy od " << distance(coll.begin(),pos) +1
            << ". elementu" << endl;
   }
   else {
       cout << "nie znaleziono czterech kolejnych elementow o wartosci 3"
            << endl;
   }

   // znajdz cztery kolejne elementy o wartosci wiekszej od 3
   pos = search_n (coll.begin(), coll.end(),    // zakres
                   4,                           // liczba elementow
                   3,                           // wartosc
                   greater<int>());             // kryterium

   // wypisz wynik
   if (pos != coll.end()) {
       cout << "cztery kolejne elementy o wartosciach > 3 "
            << "wystepuja na pozycjach poczawszy od " << distance(coll.begin(),pos) +1
            << ". elementu" << endl;
   }
   else {
       cout << "nie znaleziono czterech kolejnych elementow o wartosciach > 3"
            << endl;
   }
}
