/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    set<int> coll;

    INSERT_ELEMENTS(coll,1,9);
    PRINT_ELEMENTS(coll);

    // wypisz elementy przesuniete cyklicznie jeden element w lewo
    set<int>::iterator pos = coll.begin();
    advance(pos,1);
    rotate_copy(coll.begin(),                     // poczatek zrodla
                pos,                              // nowy pierwszy element
                coll.end(),                       // koniec zrodla
                ostream_iterator<int>(cout," ")); // przeznaczenie
    cout << endl;

    // wypisz elementy przesuniete cyklicznie dwa elementy w prawo
    pos = coll.end();
    advance(pos,-2);
    rotate_copy(coll.begin(),                     // poczatek zrodla
                pos,                              // nowy pierwszy element
                coll.end(),                       // koniec zrodla
                ostream_iterator<int>(cout," ")); // przeznaczenie
    cout << endl;

    // wypisz elementy przesuniete cyklicznie tak, zeby poczatkiem byl element o wartosci 4
    rotate_copy(coll.begin(),                     // poczatek zrodla
                coll.find(4),                     // nowy pierwszy element
                coll.end(),                       // koniec zrodla
                ostream_iterator<int>(cout," ")); // przeznaczenie
    cout << endl;
}
