/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference"
 * by Nicolai M. Josuttis, Addison-Wesley, 1999
 *
 * (C) Copyright Nicolai M. Josuttis 1999.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

// obiekt funkcyjny dodajacy wartosc, ktora zostal zainicjalizowany
template <class T>
class AddValue {
  private:
    T theValue;    // wartosc do dodania
  public:
    // konstruktor inicjalizuje wartosc do dodania
    AddValue (const T& v) : theValue(v) {
    }

    // wywolanie funkcji wobec elementu dodaje wartosc
    void operator() (T& elem) const {
        elem += theValue;
    }
};

int main()
{
    vector<int> coll;

    INSERT_ELEMENTS(coll,1,9);

    // do kazdego elementu dodaj wartosc 10
    for_each (coll.begin(), coll.end(),       // zakres
              AddValue<int>(10));             // operacja
    PRINT_ELEMENTS(coll);

    // do kazdego elementu dodaj wartosc pierwszego elementu
    for_each (coll.begin(), coll.end(),       // zakres
              AddValue<int>(*coll.begin()));  // operacja
    PRINT_ELEMENTS(coll);
}
