/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <string>
#include <fstream> // dla ofstream
#include <memory>  // dla shared_ptr
#include <cstdio>  // dla remove()

class FileDeleter
{
  private:
    std::string filename;
  public:
    FileDeleter (const std::string& fn)
     : filename(fn) {
    }
    void operator () (std::ofstream* fp) {
        fp->close();  // zamknij plik
        std::remove(filename.c_str()); // usuń plik
    }
};

int main()
{
    // utwórz i otwórz plik tymczasowy
    std::shared_ptr<std::ofstream> fp(new std::ofstream("tmpfile.txt"),
    FileDeleter("tmpfile.txt"));
    //...
}
