/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <string>
#include <iostream>
#include <algorithm>
#include <cctype>
#include <regex>
using namespace std;


int main()
{
    // utwórz łańcuch znakowy
    string s("Kod pocztowy miasta Warszawa w Polsce - 00-120");
    cout << "oryginalny:      " << s << endl;

    // zamień wszystkie znaki na małe litery
    transform (s.cbegin(), s.cend(),  // źródło
               s.begin(),             // łańcuch docelowy
               ::tolower);            // operacja
    cout << "małe litery:     " << s << endl;

    // zamień wszystkie znaki na wielkie litery
    transform (s.cbegin(), s.cend(),  // źródło
               s.begin(),             // łańcuch docelowy
               ::toupper);            // operacja
    cout << "wielkie litery:  " << s << endl;

    // wyszukaj Warszawa (bez uwzględniania wielkości liter)
    string g("Warszawa");
    string::const_iterator pos;
    pos = search (s.cbegin(),s.cend(),  // łańcuch źródłowy, w którym szukamy
                  g.cbegin(),g.cend(),  // ciąg szukany
                  [] (char c1, char c2) {   // kryterium porównania
                      return toupper(c1) == toupper(c2);
                  });
    if (pos != s.cend()) {
        cout << "podciąg \"" << g << "\" znaleziony pod indeksem "
             << pos - s.cbegin() << endl;
    }
}

