/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <algorithm>
#include <list>
#include <iostream>
using namespace std;

int main()
{
    list<int> coll;

    // wstaw elementy do 20 do 40
    for (int i=20; i<=40; ++i) {
        coll.push_back(i);
    }

    // ustal pozycję elementu o wartości 3
    // - nie ma takiego elementu, a więc iterator pos otrzymuje wartość funkcji coll.end()
    auto pos3 = find (coll.begin(), coll.end(),    // zakres
                      3);                          // wartość
    
    // odwróć kolejność elementów pomiędzy znalezionym elementem a końcem zakresu
    // - ponieważ iterator pos3 równy jest wartości funkcji coll.end(), odwracany jest pusty zakres
    reverse (pos3, coll.end());

    // ustal pozycję wartości 25 oraz 35
    list<int>::iterator pos25, pos35;
    pos25 = find (coll.begin(), coll.end(),  // zakres
                  25);                       // wartosc
    pos35 = find (coll.begin(), coll.end(),  // zakres
                  35);                       // wartosc

    // wypisz największa wartość z odpowiedniego zakresu
    // - uwaga: włacznie z pos25, lecz bez pos35
    cout << "max: " << *max_element (pos25, pos35) << endl;

    // przetwarzaj elementy włącznie z ostatnią pozycją
    cout << "max: " << *max_element (pos25, ++pos35) << endl;
}
