/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <complex>
#include <cstdlib>
#include <limits>
#include <cstdio>
using namespace std;

int main()
{
    complex<long double> c1, c2;

    while (cin.peek() != EOF) {

        // odczytaj pierwszą liczbę zespoloną
        cout << "liczba zespolona c1: ";
        cin >> c1;
        if (!cin) {
            cerr << "błąd podczas operacji odczytu" << endl;
            return EXIT_FAILURE;
        }

        // odczytaj druga liczbę zespoloną
        cout << "liczba zespolona c2: ";
        cin >> c2;
        if (!cin) {
            cerr << "błąd podczas operacji odczytu" << endl;
            return EXIT_FAILURE;
        }

        if (c1 == c2) {
            cout << "liczby c1 oraz c2 sa równe !" << endl;
        }

        cout << "liczba c1 podniesiona do potęgi c2: " << pow(c1,c2)
             << endl << endl;

        // pomiń resztę wiersza
        cin.ignore(numeric_limits<int>::max(),'\n');
    }
}
