/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <locale>
#include <exception>
#include <cstdlib>
using namespace std;

int main()
{
   try {
        // wykorzystaj klasyczne ustawienia języka C przy wczytywaniu danych ze standardowego wejscia
        cin.imbue(locale::classic());

        // wykorzystaj ustawienia dla jezyka niemieckiego przy zapisie danych na standardowe wyjscie
        // - różne ustawienia dla Windows i POSIX
#ifdef _MSC_VER
        cout.imbue(locale("deu_deu.1252"));
#else
        cout.imbue(locale("de_DE"));

        // wczytaj w pętli i wypisz wartości zmiennoprzecinkowe
        cout << "wpisz liczby zmiennoprzecinkowe (notacja klasyczna):"
             << endl;
        double value;
        while (cin >> value) {
            cout << value << endl;
        }
    } catch (const std::exception& e) {
        cerr << "WYJĄTEK: " << e.what() << endl;
        return EXIT_FAILURE;
    }
}
