/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
/* ************************************************************
 *  Stack.hpp
 *   - bezpieczniejsza oraz bardziej wygodna klasa stosu
 * ************************************************************/
#ifndef STACK_HPP
#define STACK_HPP
#include <deque>
#include <exception>

template <class T>
class Stack {
  protected:
    std::deque<T> c;        // kontener zawierający elementy

  public:
    // klasa wyjątku dla funkcji składowych pop() oraz top() dla pustego stosu
    class ReadEmptyStack : public std::exception {
      public:
        virtual const char* what() const throw() {
            return "próba odczytania pustego elementu";
        }
    };
  
    // liczba elementów
    typename std::deque<T>::size_type size() const {
        return c.size();
    }

    // czy stos jest pusty?
    bool empty() const {
        return c.empty();
    }

    // odłóż element na stos
    void push (const T& elem) {
        c.push_back(elem);
    }

    // zdejmij element ze stosu i zwróć jego wartosc
    T pop () {
        if (c.empty()) {
            throw ReadEmptyStack();
        }
        T elem(c.back());
        c.pop_back();
        return elem;
    }

    // zwróć wartość kolejnego elementu
    T& top () {
        if (c.empty()) {
            throw ReadEmptyStack();
        }
        return c.back();
    }
};

#endif /* STACK_HPP */

