/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
/* ************************************************************
 *  Queue.hpp
 *   - safer and more convenient queue class
 * ************************************************************/
#ifndef QUEUE_HPP
#define QUEUE_HPP

#include <deque>
#include <exception>

template <typename T>
class Queue {
  protected:
    std::deque<T> c;        // kontener na elementy kolejki

  public:
    // klasa wyjątków dla wywołań pop() front() na pustej kolejce
    class ReadEmptyQueue : public std::exception {
      public:
        virtual const char* what() const throw() {
            return "próba odczytu z pustej kolejki";
        }
    };
  
    // liczba elementów
    typename std::deque<T>::size_type size() const {
        return c.size();
    }

    // czy kolejka jest pusta?
    bool empty() const {
        return c.empty();
    }

    // wstawienie elementu do kolejki
    void push (const T& elem) {
        c.push_back(elem);
    }

    // usunięcie następnego elementu z kolejki i zwrócenie jego wartości
    T pop () {
        if (c.empty()) {
            throw ReadEmptyQueue();
        }
        T elem(c.front());
        c.pop_front();
        return elem;
    }

    // zwrócenie wartości następnego elementu w kolejce
    T& front () {
        if (c.empty()) {
            throw ReadEmptyQueue();
        }
        return c.front();
    }
};

#endif /* QUEUE_HPP */
