/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <map>
#include <string>
#include <iostream>
#include <iomanip>
#include "buckets.hpp"
using namespace std;

int main()
{
    // utwórz i zainicjalizuj multimapę jako słownik
    std::multimap<string,string> dict = {
                  {"day","dzien"},
                  {"strange","obcy"},
                  {"car","samochod"},
                  {"smart","elegancki"},
                  {"trait","cecha"},
                  {"strange","dziwny"}
    };
    printHashTableState(dict);

    // wstaw dodatkowe wartości (może spowodować przemieszanie)
    dict.insert({{"smart","sprytny"},
                 {"smart","madry"},
                 {"clever","sprytny"}
                });
    printHashTableState(dict);

    // zmodyfikuj maksymalny współczynnik obciążenia (może spowodować przemieszanie)
    dict.max_load_factor(0.7);
    printHashTableState(dict);
}

