/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <map>
#include <string>
#include <iostream>
#include <iomanip>
using namespace std;

int main()
{
    // utwórz mapę / tablicę asocjacyjną
    // - klucze są typu string
    // - wartości są typu float
    typedef map<string,float> StringFloatMap;

    StringFloatMap stocks;      // utwórz pusty kontener

    // wstaw kilka elementów
    stocks["AGORA"] = 10.67;
    stocks["COMARCH"] = 101.20;
    stocks["ZYWIEC"] = 435.00;
    stocks["TPSA"] = 9.88;
    stocks["KGHM"] = 121.80;

    // wypisz wszystkie elementy
    StringFloatMap::iterator pos;
    cout << left;  // dosuń do lewej
    for (pos = stocks.begin(); pos != stocks.end(); ++pos) {
        cout << "spolka: " << setw(12) << pos->first
             << "cena: " << pos->second << endl;
    }
    cout << endl;

    // hossa (wszystkie ceny zostają podwojone)
    for (pos = stocks.begin(); pos != stocks.end(); ++pos) {
        pos->second *= 2;
    }

    // wypisz wszystkie elementy
    for (pos = stocks.begin(); pos != stocks.end(); ++pos) {
        cout << "spolka: " << setw(12) << pos->first
             << "cena: " << pos->second << endl;
    }
    cout << endl;

    // zmień nazwę klucza "TPSA" na "Telekomunikacja Polska SA"
    // - operacja możliwa jedynie przez zamianę elementu
    stocks["Telekomunikacja Polska SA"] = stocks["TPSA"];
    stocks.erase("TPSA");

    // wypisz wszystkie elementy
    for (pos = stocks.begin(); pos != stocks.end(); ++pos) {
        cout << "spolka: " << setw(30) << pos->first
             << "cena: " << pos->second << endl;
    }
}

