/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    set<int> coll;

    INSERT_ELEMENTS(coll,1,9);
    PRINT_ELEMENTS(coll);

    // wypisz elementy przesuniete cyklicznie jeden element w lewo
    set<int>::iterator pos = coll.cbegin();
    advance(pos,1);
    rotate_copy(coll.cbegin(),                    // poczatek zrodla
                pos,                              // nowy pierwszy element
                coll.cend(),                      // koniec zrodla
                ostream_iterator<int>(cout," ")); // przeznaczenie
    cout << endl;

    // wypisz elementy przesuniete cyklicznie dwa elementy w prawo
    pos = coll.cend();
    advance(pos,-2);
    rotate_copy(coll.cbegin(),                    // poczatek zrodla
                pos,                              // nowy pierwszy element
                coll.cend(),                      // koniec zrodla
                ostream_iterator<int>(cout," ")); // przeznaczenie
    cout << endl;

    // wypisz elementy przesuniete cyklicznie tak, zeby poczatkiem byl element o wartosci 4
    rotate_copy(coll.cbegin(),                    // poczatek zrodla
                coll.find(4),                     // nowy pierwszy element
                coll.cend(),                      // koniec zrodla
                ostream_iterator<int>(cout," ")); // przeznaczenie
    cout << endl;
}
