/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    list<int> coll;

    INSERT_ELEMENTS(coll,2,7);
    INSERT_ELEMENTS(coll,4,9);
    PRINT_ELEMENTS(coll,"coll: ");

    // zastap wszystkie elementy o wartosci 6 wartoscia 42
    replace (coll.begin(), coll.end(),     // zakres
             6,                            // stara wartosc
             42);                          // nowa wartosc
    PRINT_ELEMENTS(coll,"coll: ");

    // zastap wszystkie elementy o wartosci mniejszej do 5 wartoscia 0
    replace_if (coll.begin(), coll.end(),  // zakres
                [](int elem) {             // kryterium zastapienia
                    return elem < 5;
                },
                0);                        // nowa wartosc
    PRINT_ELEMENTS(coll,"coll: ");
}
